/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.usermgmt.enumeration.AccessDomain;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class AccessDomainUtils {

    /**
     * 
     */
    private AccessDomainUtils() {
    }
    
    public static final AccessDomain PHR = 
        AccessDomain.getEnum(AccessDomain.PHR);
    
    public static final AccessDomain SM = 
        AccessDomain.getEnum(AccessDomain.SECUREMESSAGING);
    
    public static final AccessDomain MYGOALS = 
        AccessDomain.getEnum(AccessDomain.MYGOALS);    
    
    public static final AccessDomain BBGUI = 
        AccessDomain.getEnum(AccessDomain.BBGUI);    

    public static final AccessDomain NEWPHR = 
        AccessDomain.getEnum(AccessDomain.NEWPHR);    
    
    public static boolean isPHR(AccessDomain accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return PHR.equals(accessDomain);
    }

    public static boolean isPHR(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return PHR.getName().equals(accessDomain);
    }

    public static boolean isPHR(int accessDomain) {
        return PHR.getValue() == accessDomain;
    }
    public static boolean isSM(AccessDomain accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return SM.equals(accessDomain);
    }

    public static boolean isSM(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return SM.getName().equals(accessDomain);
    }

    public static boolean isSM(int accessDomain) {
        return SM.getValue() == accessDomain;
    }
    
    public static boolean isMyGoals(AccessDomain accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return MYGOALS.equals(accessDomain);
    }

    public static boolean isMyGoals(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return MYGOALS.getName().equals(accessDomain);
    }

    public static boolean isMyGoals(int accessDomain) {
        return MYGOALS.getValue() == accessDomain;
    }
    
    public static boolean isBBGUI(AccessDomain accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return BBGUI.equals(accessDomain);
    }

    public static boolean isBBGUI(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return BBGUI.getName().equals(accessDomain);
    }

    public static boolean isBBGUI(int accessDomain) {
        return BBGUI.getValue() == accessDomain;
    }
    
    // NEW PHR Element Check
    public static boolean isNewPhr(AccessDomain accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return NEWPHR.equals(accessDomain);
    }

    public static boolean isNewPhr(String accessDomain) {
        Precondition.assertNotNull("accessDomain", accessDomain);
        return NEWPHR.getName().equals(accessDomain);
    }

    public static boolean isNewPhr(int accessDomain) {
        return NEWPHR.getValue() == accessDomain;
    }    
    
}
